"use strict";const{app,clipboard,ipcMain,nativeTheme,net,powerSaveBlocker,protocol,screen,session,shell,BaseWindow,BrowserWindow,Menu,Notification,Tray,WebContentsView}=require("electron"),process=require("node:process"),macos="darwin"===process.platform,linux="linux"===process.platform,path=require("node:path"),{pathToFileURL,URLPattern}=require("node:url"),{readFile,writeFile}=require("node:fs/promises"),C=require(__dirname+"/const.js"),root=app.getAppPath(),program=Object.seal({main:null,tray:null,language:"ru",active_chats:null,external_tabs:null}),brdg=Symbol("bridge"),shared=new Map,shared_file=path.join(root,C.cache_folder,"shared.json"),apps=new Map,plugins=new Map,folders=new Map,accounts=new Map,extra_windows=new Map,shared_accounts=new Map,notifications=[];function Background(e=!1,n=nativeTheme.shouldUseDarkColors){return e?n?"#ee212529":"#eef8f9fa":n?"#212529":"#f8f9fa"}function IsAppUrl(e){if(!e.startsWith(C.base))return!1;const n=path.resolve(__dirname,e.slice(C.base.length)),t=path.relative(__dirname,n);return!(!t||t.startsWith("..")||path.isAbsolute(t))&&n}function L10N(e){const n=Object.create(null),{language:t}=program;for(let[o,s]of Object.entries(e))s=s[t]??s.en??Object.values(s).pop()??"",Array.isArray(s)&&(s=new Function(...s)),n[o]=s;return Object.freeze(n)}function AppLimits(e,n=["/window.html"]){e.webContents.on("will-navigate",(e,t)=>!IsAppUrl(t)||!n.some(e=>t.endsWith(e))&&e.preventDefault()).on("context-menu",(n,t)=>CutCopyPaste(t,e)).setWindowOpenHandler(()=>({action:"deny"}))}function Icon(e){return path.join(__dirname,"icons",e+".png")}function SetLanguage(e,n){program.language!==e&&(program.language=e,TrayMenu(),apps.forEach(([n])=>n.webContents.send("set-language",e)),BrowserWindow.getAllWindows().map(t=>t.id!==n&&t.webContents.send("set-language",e)))}function TrayMenu(){const e=L10N({about:{ru:"О программе...",en:"About..."},restart:{ru:"Перезапустить",en:"Restart"},main:{ru:"Главное окно",en:"Main window"},exit:{ru:"Выйти",en:"Quit"}}),n=Menu.buildFromTemplate([{label:e.about,icon:Icon("about"),type:"normal",click:()=>app.showAboutPanel()},{label:e.restart,icon:Icon("restart"),type:"normal",click:function(){app.relaunch(),app.quit()}},{label:e.main,id:"main",type:"checkbox",checked:!!program.main,enabled:plugins.size>0,click:function(){program.main?BrowserWindow.fromId(program.main).close():Main(),this.checked=!!program.main}},{label:e.exit,icon:Icon("close"),type:"normal",click:()=>app.quit()}]);program.tray.setContextMenu(n)}function AccountsChanged(e){apps.forEach(([n])=>n.webContents.send("accounts-changed",e))}function CutCopyPaste({isEditable:e,editFlags:n,formControlType:t,linkURL:o},s){const r=L10N({cut:{ru:"Вырезать",en:"Cut"},copy:{ru:"Копировать",en:"Copy"},paste:{ru:"Вставить",en:"Paste"},all:{ru:"Выделить всё",en:"Select all"}}),i=[];"none"!==t&&i.push(...n.canCut?[{role:"cut",icon:Icon("cut"),label:r.cut}]:[],...n.canCopy?[{role:"copy",icon:Icon("copy"),label:r.copy}]:[],...n.canPaste?[{role:"paste",icon:Icon("paste"),label:r.paste}]:[],...e&&n.canSelectAll?[{role:"selectAll",icon:Icon("select-all"),label:r.all}]:[]),i.length>0&&Menu.buildFromTemplate(i).popup({window:s})}function WebViewContextMenu({isEditable:e,editFlags:n,formControlType:t,linkURL:o},s){const r=L10N({cut:{ru:"Вырезать",en:"Cut"},copy:{ru:"Копировать",en:"Copy"},paste:{ru:"Вставить",en:"Paste"},all:{ru:"Выделить всё",en:"Select all"},reload:{ru:"Обновить",en:"Reload"},back:{ru:"Назад",en:"Back"},forward:{ru:"Вперёд",en:"Forward"},mute:{ru:"Обеззвучить",en:"Mute"},unmute:{ru:"Включить звук",en:"Unmute"},zoom_in:{ru:"Увеличить масштаб",en:"Zoom in"},zoom_out:{ru:"Уменьшить масштаб",en:"Zoom out"},zoom_reset:{ru:"Восстановить масштаб",en:"Reset zoom"}}),i=s.webContents,a=i.navigationHistory,l="none"!==t,c=[];c.push(...n.canCut&&l?[{role:"cut",icon:Icon("cut"),label:r.cut}]:[],...n.canCopy?[{role:"copy",icon:Icon("copy"),label:r.copy}]:[],...n.canPaste&&l?[{role:"paste",icon:Icon("paste"),label:r.paste}]:[],...e&&n.canSelectAll?[{role:"selectAll",icon:Icon("select-all"),label:r.all}]:[]),c.push(...c.length>0?[{type:"separator"}]:[],{label:r.reload,icon:Icon("reload"),click:(e,n,t)=>t.shiftKey?i.reloadIgnoringCache():i.reload()},...a.canGoBack()?[{label:r.back,icon:Icon("back"),click:e=>a.goBack()}]:[],...a.canGoForward()?[{label:r.forward,icon:Icon("forward"),click:e=>a.goForward()}]:[],{type:"separator"},i.audioMuted?{label:r.unmute,icon:Icon("unmute"),click:e=>i.setAudioMuted(!1)}:{label:r.mute,icon:Icon("mute"),click:e=>i.setAudioMuted(!0)},{type:"separator"},...i.zoomLevel?[{role:"resetZoom",label:r.zoom_reset,icon:Icon("zoom-reset")}]:[],{role:"zoomIn",label:r.zoom_in,icon:Icon("zoom-in")},{role:"zoomOut",label:r.zoom_out,icon:Icon("zoom-out")},{type:"separator"},{label:"DevTools",icon:Icon("devtools"),click:e=>i.openDevTools({mode:"undocked",title:i.getTitle()})}),Menu.buildFromTemplate(c).popup({window:s})}function AppMenu(e,n=[]){const{webContents:t}=e,o=[{label:L10N({clear:{ru:"Очистить кэш",en:"Clear cache"}}).clear,icon:Icon("flush"),click:e=>(t.session.clearCache(),t.reload())},{label:"DevTools",icon:Icon("devtools"),click:e=>t.openDevTools({mode:"undocked",title:t.getTitle()})},...n];Menu.buildFromTemplate(o).popup({window:e})}function SharedGet(e){return shared.get(e)}function SharedSet(e,n){null===e?shared.delete(n):shared.set(n,e)}function SetFolders(e){for(const[n,t]of Object.entries(e))folders.has(n)||folders.set(n,t)}function GetFolder(e,n){const[t]=e.split(".",1);if(folders.has(e))return t+"-"+folders.get(e);const o=[...folders.keys()].filter(e=>e.startsWith(t+".")).map(e=>folders.get(e));for(let s=1;s<1/0;s++)if(!o.includes(s))return folders.set(e,s),n.webContents.send("message","folders",Object.fromEntries(folders)),t+"-"+s}function DeleteFolder(e,n){if(!folders.has(e))return!0;const[t]=e.split(".",1),o=folders.get(e);folders.delete(e),n.webContents.send("message","folders",Object.fromEntries(folders));return![...folders.keys()].filter(e=>e.startsWith(t+".")).map(e=>folders.get(e)).includes(o)}function CopyFolder(e,n,t){if(folders.has(n)||!folders.has(e))return!1;const o=folders.get(e);return folders.set(n,o),t.webContents.send("message","folders",Object.fromEntries(folders)),!0}function SharedAccount(e,n=null,t=null,o=null){if(o)shared_accounts.has(n)||shared_accounts.set(n,new Map),shared_accounts.get(n).set(o,[e,t]);else if(null===n)for(const[n,t]of shared_accounts){for(const[n,o]of t)o[0]===e&&t.delete(n);t.size<1&&shared_accounts.delete(n)}else{if(!shared_accounts.has(n))return;{const o=shared_accounts.get(n);for(const[n,s]of o)s[0]===e&&s[1]===t&&o.delete(n);o.size<1&&shared_accounts.delete(n)}}const s=shared_accounts.has(n)?shared_accounts.get(n).keys():null;for(const[,[e]]of apps)e.webContents.send("message","shared-accounts",n,s)}function SharedAccounts(e){return shared_accounts.has(e)?shared_accounts.get(e).keys():null}async function SharedLogin(e,n,t,o,s,r,i,a,...l){if(!shared_accounts.has(i))return!1;const c=shared_accounts.get(i);if(!c.has(a))return!1;const d=c.get(a);return await WebViewDelete(e.contentView,n,t,s,r),CopyFolder(d.join("."),s+"."+r,n),WebViewCreate(e,n,t,o,s,r,...l)}async function MakeNotification(e,n,t){if(notifications.some(e=>e[0]===n)){const[,,e,o]=notifications.find(e=>e[0]===n);for(const n of["title","body"])Object.hasOwn(t,n)&&(e[n]=t[n]);return e.show(),o}const o=new Notification(t),{promise:s,resolve:r,reject:i}=Promise.withResolvers();return o.once("click",e=>r("click")).once("reply",(e,n)=>r(["reply",n])).once("action",(e,n)=>r(["action",n])).once("failed",(e,n)=>i(n)).once("close",function(e){const t=notifications.findIndex(e=>e[0]===n);t>-1&&notifications.splice(t,1),r("close")}),o.show(),notifications.push([n,e,o,s]),s}function ClearNotification(e,n){const t=notifications.find(e=>e[0]===n);if(t){const e=notifications.indexOf(t);t[2].close(),e>-1&&notifications.splice(e,1)}}function Main(){const e=new BrowserWindow({width:800,height:682,center:!0,resizable:!1,maximizable:!1,title:"🍒 Sender.Services",icon:path.join(__dirname,"favicon.ico"),backgroundColor:Background(),titleBarStyle:"hidden",webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-main.js")},vibrancy:"window",titleBarOverlay:{height:35}}),n=e.webContents,{ipc:t}=n;AppLimits(e,["/window.html","/start.html"]),e.setMenu(null),e.setResizable(!1),e.once("closed",function(e){program.main=null,plugins.size<1&&(BaseWindow.getAllWindows().map(e=>e.close()),BrowserWindow.getAllWindows().map(e=>e.close()))}),n.on("did-navigate",function(e,n){if(n.endsWith("/window.html")){const e=JSON.stringify({style:"main",template:"main",script:"main",settings:{macos,linux,ua:C.ua}});this.executeJavaScript(`Init(${e})`)}});for(const n of["ip-activation","ip-activated","set-dark"])t.on(n,(t,...o)=>IsAppUrl(t.senderFrame.url)&&BrowserWindow.getAllWindows().map(t=>t.id!==e.id&&t.webContents.send(n,...o))&&apps.forEach(([e])=>e.webContents.send(n,...o)));t.on("plugin",(e,...n)=>IsAppUrl(e.senderFrame.url)&&PluginWindow(...n)).on("app-menu",n=>IsAppUrl(n.senderFrame.url)&&AppMenu(e)).on("accounts-changed",(e,n)=>IsAppUrl(e.senderFrame.url)&&AccountsChanged(n)).once("set-folders",(e,...n)=>IsAppUrl(e.senderFrame.url)&&SetFolders(...n)).once("set-language",(n,t)=>IsAppUrl(n.senderFrame.url)&&SetLanguage(t,e.id)),e.loadURL(C.base+"start.html"),program.main=e.id}function AccountsWindow(e){if(accounts.has(e)){const n=BrowserWindow.fromId(accounts.get(e));return n.isMinimized()&&n.restore(),n.focus()}const n=new BrowserWindow({width:390,height:500,center:!0,resizable:!1,maximizable:!1,title:"🍒 Sender.Services",icon:path.join(__dirname,"favicon.ico"),backgroundColor:Background(),titleBarStyle:"hidden",webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-accounts.js")},vibrancy:"window",titleBarOverlay:{height:35}}),{ipc:t}=n.webContents;accounts.set(e,n.id),n.once("closed",()=>accounts.delete(e)),AppLimits(n),n.setMenu(null),n.setResizable(!1),n.webContents.on("did-navigate",function(n,t){const o=JSON.stringify({style:"accounts",template:"accounts",script:"accounts",settings:{site:e,macos,linux,show_list:!0}});this.executeJavaScript(`Init(${o})`)}),t.on("app-menu",e=>IsAppUrl(e.senderFrame.url)&&AppMenu(n)).on("accounts-changed",n=>IsAppUrl(n.senderFrame.url)&&AccountsChanged([e])),n.loadURL(C.base+"window.html")}function ActiveChats(e,n=null,...t){if(null===n){if(null!==program.active_chats){const e=BrowserWindow.fromId(program.active_chats);return e.isMinimized()&&e.restore(),e.focus()}const e=new BrowserWindow({width:430,height:430,minWidth:430,minHeight:430,center:!0,title:"🍒 Sender.Services",icon:path.join(__dirname,"favicon.ico"),backgroundColor:Background(),titleBarStyle:"hidden",webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-chats.js")},vibrancy:"window",titleBarOverlay:{height:35}}),{ipc:n}=e.webContents;return program.active_chats=e.id,e.once("closed",function(){program.active_chats=null}),AppLimits(e),e.setMenu(null),e.webContents.on("did-navigate",function(e,n){const t=JSON.stringify({style:"active-chats",template:"active-chats",script:"active-chats",settings:{macos,linux}});this.executeJavaScript(`Init(${t})`)}),n.on("message",function(e,n,...t){IsAppUrl(e.senderFrame.url)&&(null===n?apps.forEach(([e])=>e.webContents.send("active-chats",...t)):apps.has(n)&&apps.get(n).at(0).webContents.send("active-chats",...t))}).on("app-menu",n=>IsAppUrl(n.senderFrame.url)&&AppMenu(e)),e.loadURL(C.base+"window.html")}if(null!==program.active_chats){BrowserWindow.fromId(program.active_chats).webContents.send("message",e,n,...t)}}function ExternalTabs(e,n=null,...t){if(null===n){if(null!==program.external_tabs){const e=BrowserWindow.fromId(program.external_tabs);return e.isMinimized()&&e.restore(),e.focus()}const e=new BrowserWindow({width:700,height:520,minWidth:700,minHeight:520,center:!0,title:"🍒 Sender.Services",icon:path.join(__dirname,"favicon.ico"),backgroundColor:Background(),titleBarStyle:"hidden",webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-tabs.js")},vibrancy:"window",titleBarOverlay:{height:35}}),{ipc:n}=e.webContents;return program.external_tabs=e.id,e.once("closed",function(){program.external_tabs=null}),AppLimits(e),e.setMenu(null),e.webContents.on("did-navigate",function(e,n){const t=JSON.stringify({style:"external-tabs",template:"external-tabs",script:"external-tabs",settings:{macos,linux}});this.executeJavaScript(`Init(${t})`)}),n.on("message",function(e,n,...t){IsAppUrl(e.senderFrame.url)&&(null===n?apps.forEach(([e])=>e.webContents.send("external-tabs",...t)):apps.has(n)&&apps.get(n).at(0).webContents.send("external-tabs",...t))}).on("app-menu",n=>IsAppUrl(n.senderFrame.url)&&AppMenu(e)),e.loadURL(C.base+"window.html")}if(null!==program.external_tabs){BrowserWindow.fromId(program.external_tabs).webContents.send("message",e,n,...t)}}function ExtraWindow(e,n,t,o){if(extra_windows.has(t)){const e=BaseWindow.fromId(extra_windows.get(t)),s=e.contentView.children.find(e=>e.webContents.session===o.session);return s&&s.webContents.loadURL(n),e.isMinimized()&&e.restore(),e?.focus()}const{width:s,height:r}=screen.getPrimaryDisplay().workAreaSize,i=Math.round(s/4*3),a=Math.round(r/4*3),l=new BaseWindow({icon:path.join(__dirname,"favicon.ico"),title:"🍒 Sender.Services",minWidth:770,minHeight:520,width:i,height:a,parent:e,backgroundColor:Background(!1),titleBarStyle:"hidden",titleBarOverlay:{height:35}}),c=()=>l.close(),d=new WebContentsView({webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-ew.js")}}),p=d.webContents,u=new WebContentsView({webPreferences:{session:o.session}}),w=u.webContents,h={x:0,y:0,width:i,height:a};extra_windows.set(t,l.id),l.contentView.addChildView(d),d.setBounds({x:0,y:0,width:i,height:a}),d.setBackgroundColor(Background(!0)),AppLimits(d),l.setMenu(null),l.once("closed",function(){w.close(),p.close(),o.off("destroyed",c),extra_windows.delete(t)}).on("resize",function(){const e=this.getContentBounds();e.x=0,e.y=0,d.setBounds(e),h.width=e.width,h.height=e.height-h.y,u.setBounds(h)}),o.once("destroyed",c),p.on("did-start-navigation",e=>e.isMainFrame?u.setVisible(!1):null).on("did-navigate",function(e){const o=JSON.stringify({style:"extra-window",template:"extra-window",script:"extra-window",settings:{macos,linux,url:n,of_ss:t.endsWith("stats")}});this.executeJavaScript(`Init(${o})`)}),p.ipc.on("app-menu",e=>IsAppUrl(e.senderFrame.url)&&AppMenu(d)).on("modal-show",e=>IsAppUrl(e.senderFrame.url)&&l.contentView.addChildView(d)).on("modal-hide",e=>IsAppUrl(e.senderFrame.url)&&l.contentView.addChildView(u)).on("webview-back",e=>IsAppUrl(e.senderFrame.url)&&w.navigationHistory.goBack()).on("webview-stop",e=>IsAppUrl(e.senderFrame.url)&&w.stop()).on("webview-load",(e,n)=>IsAppUrl(e.senderFrame.url)&&w.loadURL(n)).on("webview-reload",(e,n)=>IsAppUrl(e.senderFrame.url)&&WebViewReload(u,n)).on("webview-forward",e=>IsAppUrl(e.senderFrame.url)&&w.navigationHistory.goForward()).on("webview-zoom-in",e=>IsAppUrl(e.senderFrame.url)&&WebViewZoomIn(u)).on("webview-zoom-out",e=>IsAppUrl(e.senderFrame.url)&&WebViewZoomOut(u)).on("webview-zoom-reset",e=>IsAppUrl(e.senderFrame.url)&&WebViewZoomReset(u)).on("webview-show",function(e,t){IsAppUrl(e.senderFrame.url)&&(Object.assign(h,t),l.contentView.addChildView(u),u.setVisible(!0),u.setBounds(h),""===w.getURL()?w.loadURL(n):w.reload())}).on("parent",function(e,n){IsAppUrl(e.senderFrame.url)&&(o.loadURL(n),l.close())}),w.on("did-navigate",(e,n)=>p.send("message","loaded",n,w.navigationHistory.canGoBack(),w.navigationHistory.canGoForward(),w.getTitle())).on("did-fail-load",(e,n,t,o,s)=>s?p.send("message","failed",o,n,t,w.navigationHistory.canGoBack(),w.navigationHistory.canGoForward(),w.getTitle()):null).on("page-title-updated",(e,n)=>p.send("message","title",n)).on("did-navigate-in-page",(e,n)=>p.send("message","loaded",n,w.navigationHistory.canGoBack(),w.navigationHistory.canGoForward(),w.getTitle())).on("context-menu",(e,n)=>WebViewContextMenu(n,u)),w.setWindowOpenHandler(({url:e})=>(w.loadURL(e),{action:"deny"})),p.loadURL(C.base+"window.html")}function AppSession(){const e=session.fromPath(path.join(root,C.cache_folder,"1")),{protocol:n}=e;return n.isProtocolHandled(C.protocol)||n.handle(C.protocol,({url:e})=>{const n=IsAppUrl(e);return n?net.fetch(pathToFileURL(n).toString()):new Response("bad",{status:400,headers:{"content-type":"text/plain"}})}),n.isProtocolHandled("https")||n.handle("https",n=>"OPTIONS"===n.method?new Response:e.fetch(n,{bypassCustomProtocolHandlers:!0})),e.webRequest.onHeadersReceived((e,n)=>n({responseHeaders:{...e.responseHeaders,"access-control-allow-origin":C.base.slice(0,-1),"content-security-policy":"script-src https://cdn.jsdelivr.net/ https://*.sender.services:3110/ 'self' 'unsafe-eval'"}})),e.setUserAgent(C.ua,C.ual),e}function PluginWindow({site:e,section:n,instance:t,background:o,icon:s,dark:r=nativeTheme.shouldUseDarkColors}){const i=e+"."+n;if(i.match(/[^a-z_\d.]/))return;if(plugins.has(i)){const e=plugins.get(i),n=BaseWindow.fromId(e.at(-1).at(0));if(n&&(!t||e.length>2))return n.isMinimized()&&n.restore(),n.focus()}if(t){const e=plugins.get(i)??[];for(let n=0;n<1/0;n++)if(!e.some(e=>e[1]===n)){t=n;break}}else t=0;const{width:a,height:l}=screen.getPrimaryDisplay().workAreaSize,c=Math.round(a/5*4),d=Math.round(l/5*4),p=i+"."+t,u=new BaseWindow({icon:path.join(__dirname,"favicon.ico"),title:"🍒 Sender.Services",show:!1,center:!0,minWidth:1e3,minHeight:770,width:c,height:d,backgroundColor:Background(!1,r),titleBarStyle:"hidden",titleBarOverlay:{height:35}}),{id:w}=u,h=new WebContentsView({webPreferences:{session:AppSession(),preload:path.join(__dirname,"preload-app.js")}}),m=h.webContents,{ipc:g}=m,f=new Map,b=function(){if(f.delete("active"),f.forEach(e=>e.webContents.close()),f.clear(),null!==program.external_tabs){BrowserWindow.fromId(program.external_tabs).webContents.send("message",p,"window-closed")}},y={x:0,y:0,width:0,height:0};if(u.contentView.addChildView(h),h.setBounds({x:0,y:0,width:c,height:d}),h.setBackgroundColor(Background(!0,r)),apps.set(p,[h,w]),o?u.showInactive():u.show(),AttachBridge(h),g.on("message",(e,n,...t)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.send("message","app",...t)),g.handle("request",async(e,n,...t)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n)[brdg]("app",...t)),plugins.has(i)){plugins.get(i).push([w,t])}else plugins.set(i,[[w,t]]);AppLimits(h),u.setMenu(null),u.on("close",()=>m.send("close")),u.once("closed",function(){m.close(),apps.delete(p),b();const e=plugins.get(i),n=e.indexOf(w);n>-1&&e.splice(n,1),e.length<1&&plugins.delete(i);let t=notifications.length;for(;t-- >0;)notifications[t][1]===p&&(notifications[t][2].close(),notifications.splice(t,1));SharedAccount(p),ActiveChats(p,"window-closed"),ExternalTabs(p,"window-closed")}).on("resize",function(){const e=this.getContentBounds();e.x=0,e.y=0,h.setBounds(e),y.width=e.width,y.height=e.height-y.y,f.get("active")?.setBounds(y)}),m.on("did-navigate",function(t,o){b();const r=JSON.stringify({icon:s,style:"plugin",template:"plugin",script:"plugin",settings:{site:e,section:n,macos,linux}});this.executeJavaScript(`Init(${r})`)});const v=[{type:"separator"},{label:"WebView",icon:Icon("devtools"),click:function(){const e=f.get("active")?.webContents;e&&e.openDevTools({mode:"undocked",title:e.getTitle()})}}];g.on("app-menu",e=>IsAppUrl(e.senderFrame.url)&&AppMenu(h,v)).on("modal-show",e=>IsAppUrl(e.senderFrame.url)&&u.contentView.addChildView(h)).on("modal-hide",e=>IsAppUrl(e.senderFrame.url)&&u.contentView.addChildView(f.get("active"))).on("active-chats",(e,...n)=>IsAppUrl(e.senderFrame.url)&&ActiveChats(p,...n)).on("external-tabs",(e,...n)=>IsAppUrl(e.senderFrame.url)&&ExternalTabs(p,...n)).on("shared-account",(e,...n)=>IsAppUrl(e.senderFrame.url)&&SharedAccount(p,...n)).on("webview-back",(e,n)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.navigationHistory.goBack()).on("webview-stop",(e,n)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.stop()).on("webview-load",(e,n,t)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.loadURL(t)).on("webview-flush",(e,n)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.navigationHistory.clear()).on("webview-reload",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewReload,f,...n)).on("webview-forward",(e,n)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.navigationHistory.goForward()).on("webview-zoom-in",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewZoomIn,f,...n)).on("webview-zoom-out",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewZoomOut,f,...n)).on("webview-zoom-reset",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewZoomReset,f,...n)).on("webview-ua",(e,n,t)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.setUserAgent(t)).on("webview-show",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViewShow(u.contentView,h,f,y,...n)).on("webview-clear",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewClear,f,...n)).on("webview-focus",(e,n)=>IsAppUrl(e.senderFrame.url)&&f.has(n)&&f.get(n).webContents.focus()).on("webview-permissions",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewPermissions,f,...n)).on("webview-modify-headers",(e,...n)=>IsAppUrl(e.senderFrame.url)&&WebViews(WebViewModifyHeaders,f,...n)).on("webview-height",function(e,n,t){IsAppUrl(e.senderFrame.url)&&(y.y=n,y.height=t,f.get("active")?.setBounds(y))}),g.handle("webview-create",async(e,...n)=>IsAppUrl(e.senderFrame.url)?WebViewCreate(u,h,f,y,p,...n):null),g.handle("webview-delete",async(e,...n)=>IsAppUrl(e.senderFrame.url)?WebViewDelete(u.contentView,h,f,p,...n):null),g.handle("webview-copy",async(e,...n)=>IsAppUrl(e.senderFrame.url)?WebViewCopy(h,p,...n):null),g.handle("shared-login",async(e,...n)=>IsAppUrl(e.senderFrame.url)?SharedLogin(u,h,f,y,p,...n):null),g.handle("shared-accounts",async(e,...n)=>IsAppUrl(e.senderFrame.url)?SharedAccounts(...n):null),g.on("shared-set",(...e)=>SharedSet(...e)),g.handle("shared-get",(...e)=>SharedGet(...e)),g.on("notification-clear",(e,...n)=>IsAppUrl(e.senderFrame.url)&&ClearNotification(p,...n)),g.handle("notification",async(e,...n)=>IsAppUrl(e.senderFrame.url)?MakeNotification(p,...n):null),m.loadURL(C.base+"window.html")}async function WebViewCreate(e,n,t,o,s,r,i,a,l,c=null,d=null,p=null,u=null,w={},h=[],m=[]){if(!Number.isInteger(r))return!1;const g=GetFolder(s+"."+r,n),f=session.fromPath(path.join(root,C.cache_folder,g)),b=new WebContentsView({webPreferences:{disableDialogs:!0,preload:path.join(__dirname,"preload-webview.js"),session:f}}),y=b.webContents,v=n.webContents,{ipc:A}=y,I=a.map(e=>new URLPattern(e));if(b.setVisible(!1),b.setBounds(o),t.set(r,b),e.contentView.addChildView(b),AttachBridge(b),A.on("message",(e,...n)=>v.send("webview",r,...n)),A.handle("request",async(e,...t)=>n[brdg]("webview",r,...t)),A.on("extra-window",(n,t,o)=>ExtraWindow(e,t,s+"."+o,y)),A.on("ua",(e,n)=>y.setUserAgent(n)),f.setUserAgent(C.ua,C.ual),y.setUserAgent(c||C.ua),WebViewPermissions(b,w),Array.isArray(u))for(const[e,n]of tab.rr)f.webRequest.onBeforeRequest({urls:[e+"*"],types:["script"]},({url:t})=>({redirectUrl:t.replace(e,n)}));d&&(f.setProxy({mode:"fixed_servers",proxyRules:d.host+":"+d.port,proxyBypassRules:"*.sender.services"}),y.on("login",function(e,n,t,o){t.isProxy?o(d.user,d.pass):o()}));let F=!0;if(y.on("did-start-navigation",e=>e.isMainFrame&&!e.isSameDocument?v.send("webview",r,"loading"):null).on("did-navigate",function(e,n){const t=F;F=I.length<1||I.some(e=>e.test(n)),F&&!t&&y.navigationHistory.clear(),F&&p&&y.send("script",p,"inject"),v.send("webview",r,"loaded",n)}).on("did-fail-load",(e,n,t,o,s)=>s?v.send("webview",r,"failed",o,n,t):null).on("context-menu",(e,n)=>WebViewContextMenu(n,b)),y.on("dom-ready",()=>F?y.send("eval",l,"cs"):v.send("webview",r,"mismatch")),A.on("eval-result",(e,t,o)=>"cs"===t?n[brdg]("",r).then((...e)=>y.send("message","",...e)):console.log([o])),A.on("script-result",(e,n,t)=>console.log([t])),A.on("shared-set",(...e)=>SharedSet(...e)),A.handle("shared-get",async(...e)=>SharedGet(...e)),h.length>0&&m.length<1&&m.push(i.endsWith("/")?i+"*":i+"/*"),h.includes("qpid")&&f.webRequest.onHeadersReceived({urls:m,types:["mainFrame","xhr"]},function(e,n){const t=e.responseHeaders;Array.isArray(t["set-cookie"])&&(t["set-cookie"]=t["set-cookie"].map(e=>e.replace(/\.?www\d?/i,""))),n({responseHeaders:t})}),h.includes("nocsp")&&f.webRequest.onHeadersReceived({urls:m,types:["mainFrame"]},function(e,n){const t=e.responseHeaders;delete t["content-security-policy"],n({responseHeaders:t})}),h.includes("cors")){const e=new Map,n=m.map(e=>new URLPattern(e));f.webRequest.onSendHeaders({urls:m,types:["xhr"]},function(n){n.requestHeaders.Origin&&e.set(n.id,n.requestHeaders.Origin)}),f.webRequest.onHeadersReceived({urls:m,types:["xhr"]},function(n,t){const{id:o,responseHeaders:s}=n;e.has(o)&&Object.assign(s,{"access-control-allow-origin":[e.get(o)],"access-control-allow-credentials":["true"]}),e.delete(o),t({responseHeaders:s})}),y.on("will-navigate",()=>f.protocol.unhandle("https")).on("did-navigate",()=>f.protocol.isProtocolHandled("https")||f.protocol.handle("https",e=>"OPTIONS"===e.method&&n.some(n=>n.test(e.url))?new Response:f.fetch(e,{bypassCustomProtocolHandlers:!0})))}return ServerRequests(f),y.setWindowOpenHandler(({url:n})=>(ExtraWindow(e,n,s,y),{action:"deny"})),y.loadURL(i),!0}function ServerRequests({webRequest:e}){const n=new Map,t=["https://*.sender.services/*"];e.onSendHeaders({urls:t,types:["xhr"]},function(e){e.requestHeaders.Origin&&n.set(e.id,e.requestHeaders.Origin)}),e.onHeadersReceived({urls:t,types:["xhr"]},function(e,t){const{id:o,responseHeaders:s}=e;n.has(o)&&(s["access-control-allow-origin"]=[n.get(o)]),n.delete(o),t({responseHeaders:s})})}async function WebViewDelete(e,n,t,o,s){const r=t.get("active"),i=t.get(s),a=DeleteFolder(o+"."+s,n);r===i&&t.delete("active"),t.delete(s),e.removeChildView(i),i.webContents.close(),a&&await i.webContents.session.clearStorageData()}function WebViewCopy(e,n,t,o){return CopyFolder(n+"."+t,n+"."+o,e)}function WebViews(e,n,t,...o){n.has(t)&&e(n.get(t),...o)}function WebViewPermissions({webContents:e},n){e.session.setPermissionRequestHandler(function(e,t,o){Object.hasOwn(n,t)?o(!!n[t]):o(["media","clipboard-read","clipboard-sanitized-write","notifications","openExternal"].includes(t))}),e.session.setPermissionCheckHandler(function(e,t,o,s){return"media"===t&&["audio","video"].includes(s.mediaType)&&Object.hasOwn(n,s.mediaType)?!!n[s.mediaType]:Object.hasOwn(n,t)?!!n[t]:["clipboard-read","clipboard-sanitized-write","notifications","openExternal"].includes(t)})}async function WebViewClear({webContents:e},n){await e.session.clearStorageData(),n?(await e.loadURL(n),e.navigationHistory.clear()):(e.navigationHistory.clear(),e.reload())}function WebViewReload({webContents:e},n){n?e.reloadIgnoringCache():e.reload()}function WebViewZoomIn({webContents:e}){const n=e.getZoomFactor();n<=2.8&&e.setZoomFactor(n+.2)}function WebViewZoomOut({webContents:e}){const n=e.getZoomFactor();n>=.8&&e.setZoomFactor(n-.2)}function WebViewZoomReset({webContents:e}){e.setZoomFactor(1)}function WebViewShow(e,n,t,o,s,r,i=!1){const a=t.get("active"),l=t.get(s);a&&a.setVisible(!1),Object.assign(o,r),l.setVisible(!0),l.setBounds(o),t.set("active",l),e.children.indexOf(n)>e.children.indexOf(l)&&e.addChildView(l),i&&l.webContents.focus()}function WebViewModifyHeaders(e,n){const{replace:t={}}=n;e.webContents.session.webRequest.onBeforeSendHeaders({urls:n.urls,types:["xhr"]},function({requestHeaders:e},n){let o={},s=!1,r=!1;for(const[n,i]of Object.entries(e))if(Object.hasOwn(t,n)&&(e[n]=t[n]),r=!0,n.startsWith("x-modify"))try{Object.assign(o,JSON.parse(i)),s=!0}catch(e){}if(s)for(const[n,t]of Object.entries(o))Object.hasOwn(e,n)&&(e[n]=t);n(r||s?{requestHeaders:e}:{})})}function AttachBridge(e){let n=e.webContents,t=0,o=new Map;n.ipc.on("reply",function(e,n,...t){o.has(n)?(o.get(n)(...t),o.delete(n)):console.error("Wrong reply id: "+n)}),e[brdg]=async function(...e){const{promise:s,resolve:r}=Promise.withResolvers(),i=++t;return o.set(i,(...e)=>r(...e)),n.send("request",i,...e),s}}Menu.setApplicationMenu(null),protocol.registerSchemesAsPrivileged([{scheme:C.protocol,privileges:{standard:!0,bypassCSP:!0,codeCache:!0,corsEnabled:!1}}]),powerSaveBlocker.start("prevent-app-suspension"),app.enableSandbox(),app.setPath("userData",path.join(root,C.data_folder,"0")),app.setPath("sessionData",path.join(root,C.cache_folder,"0")),app.setAboutPanelOptions({applicationName:"Sender.Services",copyright:"Maksim Pokrovsky",website:"https://sender.services/",credits:"\nFree icons from:\n🔸 Streamline https://streamlinehq.com\n🔸 Font Awesome https://fontawesome.com"}),app.whenReady().then(function(){app.configureHostResolver({enableBuiltInResolver:!1,secureDnsMode:"secure",secureDnsServers:["https://dns.quad9.net/dns-query","https://dns.google/dns-query","https://cloudflare-dns.com/dns-query","https://safe.dot.dns.yandex.net"]}),app.userAgentFallback=C.ua,Main(),app.on("activate",()=>BrowserWindow.getAllWindows().length<1&&Main()),program.tray=new Tray(Icon("logo")),program.tray.setToolTip("Sender.Services"),TrayMenu(),readFile(shared_file,{encoding:"utf8"}).then(function(e){for(const[n,t]of Object.entries(JSON.parse(e)))shared.set(n,t)}).catch(()=>null)}),app.on("window-all-closed",async function(){const e=Object.fromEntries(shared);await writeFile(shared_file,JSON.stringify(e)).catch(()=>null),!macos&&app.quit()}),ipcMain.on("accounts-window",(e,n)=>IsAppUrl(e.senderFrame.url)&&AccountsWindow(n)).on("text2clipboard",(e,n)=>IsAppUrl(e.senderFrame.url)&&clipboard.writeText(n)).on("browser",(e,n)=>IsAppUrl(e.senderFrame.url)&&n.startsWith("https://")&&shell.openExternal(n));
